#ifndef __CClipBoard__
#define __CClipBoard__

#include "../Basics/CString.hpp"
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @class CClipBoard CClipBoard.hpp
		 * @brief Provides access to the system clipboard
		 *
		 * @date 26/09/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CClipBoard.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		class CClipBoard
		{
		public:

//	===========================================================================

			/**
			 * Copy to text to the system clipboard
			 * @param text The text to place on the clipboard
			 * @retval bool True if placed correctly, false otherwise
			 */
			static bool copyStringToSystemClipboard(const CString &text);

			/**
			 * Get text from system clipboard
			 * @param text On return is filled with the text from the clipbaord
			 * @retval bool True if stored properly, false otherwise
			 */
			static bool getStringFromSystemClipboard(CString &text);

//	===========================================================================

		};
	}
}
#endif	// End of CClipBoard.hpp